﻿//////////////////////////////////////////////
// FxaaEffect.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class System ;
}

namespace nkGraphics
{
	class Program ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

#include "../Effect.h"

#include "FxaaEffectInfo.h"
#include "FxaaPreset.h"

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT FxaaEffect final : public Effect
	{
		public :

			// Constructor, destructor
			FxaaEffect (System* system) noexcept ;
			virtual ~FxaaEffect () ;

			// Getters
			nkGraphics::Texture* getSourceTexture () const ;
			float getMinContrast () const ;
			float getMinLuminance () const ;
			float getSmoothingStrength () const ;
			FXAA_PRESET getPreset () const ;
			bool getLuminanceAsGreenChannelOnly () const ;

			// Setters
			void setSourceTexture (nkGraphics::Texture* value) ;
			void setMinContrast (float value) ;
			void setMinLuminance (float value) ;
			void setSmoothingStrength (float value) ;
			void setPreset (FXAA_PRESET value) ;
			void setLuminanceAsGreenChannelOnly (bool value) ;

			// Load
			virtual bool load () override ;
			virtual void unload () override ;

		public :

			// Statics
			static nkMemory::UniquePtr<FxaaEffect> create (System* system = nullptr) ;

		private :

			// Functions
			// Program
			bool _prepareProgram () ;

			// Shader
			bool _prepareShader () ;

		private :

			// Attributes
			System* _system ;

			// Program
			nkGraphics::Program* _program ;
			FxaaEffectInfo _programInfo ;

			// Info
			FxaaEffectInfo _info ;
	} ;
}